<?php
/* --------------------------------------------------------------
   SpainVatIdValidator.php 2024-06-03
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2024 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\VatValidation\App\Validators;

/**
 * Class SpainVatIdValidator
 *
 * @package Gambio\Core\VatValidation\App\Validators
 */
class SpainVatIdValidator implements ManualVatIdValidator
{
    /**
     * @inheritDoc
     */
    public function validatedCountryIsoCode(): string
    {
        return 'es';
    }
    
    
    /**
     * @inheritDoc
     */
    public function validateVatId(string $vatId): bool
    {
        return preg_match("/^es[0-9a-z][0-9]{7}[0-9a-z]$/", strtolower($vatId)) === 1;
    }
}